#include "node_table_writer.h"
#include <library/cpp/yson/node/node_io.h>

namespace NRTYT {

void TNodeWriter::AddRow(const NYT::TNode& row, size_t tableIndex) {
    Y_ENSURE(tableIndex < GetTableCount(), "While TNodeWriter::AddRow: tableIndex " << tableIndex << " is out of range (0, " << GetTableCount());
    TBlob blob = TBlob::FromString(NYT::NodeToYsonString(row));
    Archives[tableIndex]->PutDocument(blob, RowIds[tableIndex]++);
}
void TNodeWriter::AddRow(NYT::TNode&& row, size_t tableIndex) {
    AddRow(row, tableIndex);
}

size_t TNodeWriter::GetTableCount() const {
    return ArchivePaths.size();
}
void TNodeWriter::FinishTable(size_t tableIndex) {
    Y_ENSURE(tableIndex < GetTableCount(), "While TNodeWriter::FinishTable: tableIndex " << tableIndex << " is out of range (0, " << GetTableCount());
    Archives[tableIndex]->Flush();
}

} // namespace NRTYT
