#pragma once

#include "archive_config.h"

#include <mapreduce/yt/interface/io.h>
#include <kernel/multipart_archive/multipart.h>

namespace NRTYT {

class TNodeWriter : public NYT::INodeWriterImpl {
public:
    TNodeWriter(const TVector<TString>& paths)
        : ArchivePaths(paths) { // TODO: support tableIndex
        NRTYArchive::TMultipartConfig config = DefaultArchiveConfig;
        for (const auto& path : paths) {
            Archives.push_back(TArchiveOwner::Create(path, config));
            RowIds.push_back(Archives.back()->GetDocsCount(/*withDeleted =*/ true));
        }
    }

    TNodeWriter(const TString& path)
        : TNodeWriter(TVector<TString>{path})
        {
    }
    virtual void AddRow(const NYT::TNode& row, size_t tableIndex) override;
    virtual void AddRow(NYT::TNode&& row, size_t tableIndex) override;

public: // IWriterImplBase
    virtual size_t GetTableCount() const override;
    virtual void FinishTable(size_t tableIndex) override;

private:
    TVector<TArchiveOwner::TPtr> Archives;
    TVector<TString> ArchivePaths;
    TVector<ui32> RowIds;
};

} // namespace NRTYT
