#pragma once

#include <google/protobuf/descriptor.h>
#include <google/protobuf/descriptor.pb.h>

namespace NRTYT {

int CompareValues(
    ::google::protobuf::Message* a,
    ::google::protobuf::Message* b,
    const ::google::protobuf::FieldDescriptor* descriptor,
    const ::google::protobuf::FieldDescriptor* descriptor2 = nullptr);

void SortProtoVector(TVector<THolder<::google::protobuf::Message>>& data, const TVector<const ::google::protobuf::FieldDescriptor*>& keyDescriptors);

TString SerializeFileDescriptor(const ::google::protobuf::FileDescriptor* descriptor);

TVector<const ::google::protobuf::FieldDescriptor*> GetFieldDescriptorsByName(
                    const ::google::protobuf::Descriptor* descriptor,
                    const TVector<TString>& columnNames,
                    bool ignoreUnknownColumns = false);

inline THolder<::google::protobuf::Message> CopyMessage(const THolder<::google::protobuf::Message>& old) {
    THolder<::google::protobuf::Message> result(old->New());
    result->CopyFrom(*old);
    return result;
}

inline TAtomicSharedPtr<::google::protobuf::Message> CopyMessage(const TAtomicSharedPtr<::google::protobuf::Message>& old) {
    TAtomicSharedPtr<::google::protobuf::Message> result(old->New());
    result->CopyFrom(*old);
    return result;
}
} // namespace NRTYT
