#pragma once

#include <util/folder/path.h>
#include <util/generic/string.h>
#include <util/generic/ptr.h>
#include <util/generic/vector.h>

struct TConfigEntry;
class TFsPath;
namespace NXmlRPC {
    struct TEndPoint;
}

namespace NSaas {

    struct TSandboxResourceInfo {
        TString RsyncPath;
        TString RbTorrent;
        TString ResourceType;
        TString FileName;
    };

    class TSandboxManager {
    public:
        explicit TSandboxManager(const TFsPath& workingDir);
        ~TSandboxManager();

        void EnableCustomJsonPath(bool enable) {
            UseCustomJsonPath = enable;
        }
        void SetCustomJsonPath(const TFsPath& path) {
            CustomJsonPath = path;
        }

        TVector<TSandboxResourceInfo> GetAvailableSandboxResources();

    private:
        TVector<TSandboxResourceInfo> GetTorrentsFromJsonConfig(const TFsPath& configPath);
        TVector<TSandboxResourceInfo> GetTorrentsFromSandboxJsonConfig();
        TSandboxResourceInfo GetInfoFromResourceId(const TConfigEntry&);

    private:
        const TFsPath WorkingDir;
        TFsPath CustomJsonPath;
        bool UseCustomJsonPath;

        THolder<NXmlRPC::TEndPoint> Client;
    };
}
