#include "host.h"
#include "parsers/json/json.h"

namespace NSearchMapParser {
    void TSearchMapHost::SetDefaults() {
        Rank = Master;
        SearchPort = IndexerPort = 16000;
        DisableIndexing = DisableSearch = false;
        DisableFetch = DisableSearchFiltration = false;
    }

    bool TSearchMapHost::Deserialize(const NJson::TJsonValue& value) {
        try {
            TParsingSettings parsingSettings = { false, Max<TShardIndex>(), {} };
            *this = TSearchMapHostParser(value, parsingSettings).Get();
            return true;
        } catch (const yexception& e) {
            Cerr << "cannot deserialize host: " << e.what() << Endl;
            return false;
        }
    }

    NJson::TJsonValue TSearchMapHost::Serialize() const {
        return TJsonSearchMapParser::SerializeHost(*this);
    }

}
