#pragma once
#include "search_info.h"

#include <saas/util/external/dc.h>
#include <library/cpp/json/writer/json_value.h>

namespace NSearchMapParser {
    class TSearchMapHost: public TSearchInformation {
    public:
        TSearchMapHost()
            : TSearchInformation("", 0, 0, Master, TInterval<TShardIndex>())
        {
            SetDefaults();
        }
        TSearchMapHost(const TString& name, TInterval<TShardIndex> shards, RankType rank, ui16 searchPort, ui16 indexerPort)
            : TSearchInformation(name, searchPort, indexerPort, rank, shards)
        {}
        void SetDefaults();

        TString GetSlotName() const {
            return GetDescription();
        }

        TString GetShortHostName() const {
            return NSlotNameUtil::ShortHost(Name);
        }

        TString GetShortSlotName() const {
            return GetShortHostName() + ":" + ToString(SearchPort);
        }

        ui16 ControllerPort() const {
            return SearchPort + DefaultControllerPortShift;
        }

        using TSearchInformation::Deserialize;
        bool Deserialize(const NJson::TJsonValue& value);
        NJson::TJsonValue Serialize() const;
    };

    class THostsInfoChecker {
        TMap<TString, ui32> HostAddrs;

    public:
        void AddHost(const TSearchMapHost& host) {
            HostAddrs[host.Name + ":" + ToString(host.IndexerPort)]++;
            HostAddrs[host.Name + ":" + ToString(host.SearchPort)]++;
        }
        void CheckOrThrow() const {
            for (const auto& host : HostAddrs) {
                if (host.second > 1) {
                    ythrow yexception() << "search map has duplicated hosts: " << host.first;
                }
            }
        }
    };
}
