#include "parser.h"

#include <util/stream/str.h>
#include <saas/util/json/json.h>

namespace NSearchMapParser {
    TAutoPtr<NSearchMapParser::ISearchMapParser> OpenSearchMap(const TString& searchMapString, const TParsingSettings& settings) {
        TAutoPtr<ISearchMapParser> parser = TSearchMapParserFactory::Construct("json", settings);
        Y_ENSURE(parser, "searchmap parser is not registered");

        Y_ENSURE(NUtil::ValidateJsonString(searchMapString), "searchmap json is incorrect");
        TStringInput si(searchMapString);
        parser->OpenSearchMap(si);
        return parser;
    }

    TAutoPtr<NSearchMapParser::ISearchMapParser> OpenSearchMap(const TString& searchMapString, const TSet<TString>& filterServices) {
        TParsingSettings settings;
        settings.FilterServices = filterServices;
        return OpenSearchMap(searchMapString, settings);
    }

    TAutoPtr<NSearchMapParser::ISearchMapParser> OpenSearchMap(const TString& searchMapString) {
        return OpenSearchMap(searchMapString, TParsingSettings());
    }
}

