#pragma once

#include <library/cpp/object_factory/object_factory.h>

#include <saas/util/types/shard_index.h>
#include <util/stream/input.h>
#include <utility>

namespace NSearchMapParser {

    class TSearchMap;

    struct TParsingSettings {
        bool IgnoreParsingErrors = false;
        TShardIndex ShardsNumber = SearchMapShards;
        TSet<TString> FilterServices;
    };

    class ISearchMapParser {
    public:
        virtual ~ISearchMapParser() {}

        virtual void OpenSearchMap(IInputStream& stream) = 0;
        virtual TSearchMap GetSearchMap(bool checkIndex = true, bool checkSearch = true) const = 0;
    };

    TAutoPtr<ISearchMapParser> OpenSearchMap(const TString& searchMapString, const TParsingSettings& settings);

    TAutoPtr<ISearchMapParser> OpenSearchMap(const TString& searchMapString, const TSet<TString>& filterServices);

    TAutoPtr<ISearchMapParser> OpenSearchMap(const TString& searchMapString);
}

typedef NObjectFactory::TParametrizedObjectFactory<NSearchMapParser::ISearchMapParser, TString, const NSearchMapParser::TParsingSettings&> TSearchMapParserFactory;
