#include "search_info.h"

bool NSearchMapParser::TSearchInformation::Deserialize(const NSaasProto::TRTYSlot& slot) {
    Name = slot.GetSlot().GetHost();
    SearchPort = slot.GetSlot().GetPort();
    Shards.SetMin(slot.GetShardMin());
    Shards.SetMax(slot.GetShardMax());
    IndexerPort = slot.HasIndexingPort() ? slot.GetIndexingPort() : (SearchPort + NSearchMapParser::DefaultIndexerPortShift);
    Group = slot.GetGroup();
    DC = slot.GetDC();
    DisableSearch = slot.GetDisableSearch();
    DisableIndexing = slot.GetDisableIndexing();
    DisableSearchFiltration = slot.GetDisableSearchFiltration();
    DisableFetch = slot.GetDisableFetch();
    IsSd = slot.GetIsSD();
    return true;
}

NSaasProto::TRTYSlot NSearchMapParser::TSearchInformation::SerializeToProto() const {
    NSaasProto::TRTYSlot result;
    result.MutableSlot()->SetHost(Name);
    result.MutableSlot()->SetPort(SearchPort);
    result.SetShardMin(Shards.GetMin());
    result.SetShardMax(Shards.GetMax());
    result.SetIndexingPort(IndexerPort);
    result.SetGroup(Group);
    if (DC != "" && DC != "NO_DC")
        result.SetDC(DC);
    result.SetDisableSearch(DisableSearch);
    result.SetDisableIndexing(DisableIndexing);
    result.SetDisableSearchFiltration(DisableSearchFiltration);
    result.SetDisableFetch(DisableFetch);
    result.SetIsSD(IsSd);
    return result;
}
