#pragma once

#include <util/generic/string.h>
#include <util/generic/yexception.h>

namespace NSaas {

    struct TNotAuthorizedInfo {
        TString Reason;
        int HttpCode{};
    };

    class TNotAuthorizedException: public yexception {
    public:
        TNotAuthorizedException(const TNotAuthorizedInfo& info)
            : Info(info)
        {
            (*this) << Info.Reason;
        }

        int GetHttpCode() const {
            return Info.HttpCode;
        }

        const TNotAuthorizedInfo& GetInfo() const {
            return Info;
        }

    private:
        TNotAuthorizedInfo Info;
    };

}
