#pragma once
#include <library/cpp/http/misc/httpreqdata.h>
#include <util/generic/string.h>
#include <util/string/type.h>
#include <search/request/data/reqdata.h>

class TSearchRequestDelay {
private:
    TString DelayTarget;
    bool IsValid = false;
    i32 Sleepus = 10000000;
    i32 DelayProbability = 100;
public:

    TSearchRequestDelay(const TString& paramsConf);

    bool Valid() const {
        return IsValid;
    }

    const TString& GetDelayTarget() const {
        return DelayTarget;
    }

    void Activate() const;

    static void Process(const TSearchRequestData& rd, const TString& target) {
        if (IsTrue(rd.CgiParam.Get("DF")) || (rd.CgiParam.Has("info")))
            return;
        for (size_t i = 0; i < rd.CgiParam.NumOfValues("delay"); ++i) {
            const TString& delayParams = rd.CgiParam.Get("delay", i);
            if (!!delayParams) {
                TSearchRequestDelay srd(delayParams);
                if (srd.GetDelayTarget() == target) {
                    srd.Activate();
                }
            }
        }
    }

};
