#include "exception.h"

#include <saas/library/report_builder/simple.h>
#include <search/session/reqenv.h>

#include <library/cpp/http/misc/httpcodes.h>
#include <library/cpp/http/misc/httpreqdata.h>

void MakeErrorPage(IReplyContext& context, const ui32 code, const TString& error) try {
    TRTYSimpleProtoReportBuilder builder(context);
    builder.AddErrorMessage(error);
    builder.MarkIncomplete();
    builder.Finish(code);
} catch (...) {
    DEBUG_LOG << "cannot MakeErrorPage for" << error << ": " << CurrentExceptionMessage() << Endl;
}

void MakeErrorPage(IReplyContext::TPtr context, const ui32 code, const TString& error) {
    if (context) {
        MakeErrorPage(*context, code, error);
    }
}
