#pragma once

#include <library/cpp/yconf/conf.h>
#include <library/cpp/http/misc/httpcodes.h>

struct THttpStatusManagerConfig {
    int IncompleteStatus = HTTP_BAD_GATEWAY;
    int SyntaxErrorStatus = HTTP_BAD_REQUEST;
    int EmptyRequestStatus = HTTP_BAD_REQUEST;
    int EmptySetStatus = HTTP_NOT_FOUND;
    int UnknownErrorStatus = HTTP_INTERNAL_SERVER_ERROR;
    int TimeoutStatus = HTTP_GATEWAY_TIME_OUT;
    int PartialStatus = HTTP_PARTIAL_CONTENT;
    int NotFetchedStatus = HTTP_OK;
    int UnauthorizedStatus = HTTP_UNAUTHORIZED;
    int PermissionDeniedStatus = HTTP_FORBIDDEN;
    int UnavailableStatus = 0; // todo: make 503 or 429 by default, now need to avoid total proxies behaviour change
    float PartialThreshold = 0;

public:
    THttpStatusManagerConfig() = default;
    THttpStatusManagerConfig(const TYandexConfig::Directives& directives);
};

