#pragma once

#include <search/daemons/httpsearch/yshttp.h>
#include <saas/util/network/neh_server.h>
#include "replier.h"
#include <library/cpp/neh/rpc.h>
#include <util/generic/buffer.h>

class TSearchNehServer: public NUtil::TAbstractNehServer {
protected:
    YandexHttpServer YServer;

public:
    TSearchNehServer(const TOptions& config);

    virtual void SuperMind(const TStringBuf& postdata, IOutputStream& conn, IOutputStream& headers, bool isLocal);
};

class TNehReplyContext: public IReplyContext {
public:
    virtual ~TNehReplyContext() {

    }

    virtual NNeh::IRequest& GetRequest() = 0;
    virtual NNeh::TRequestOut& GetReplyOutput() = 0;

    virtual bool IsHttp() const override {
        return false;
    }

    virtual void MakeSimpleReply(const TBuffer& buf, int code) override final;
    virtual void AddReplyInfo(const TString&, const TString&) override final {}
};
