#include <saas/library/sharding/sharding.h>
#include <saas/protos/rtyserver.pb.h>

namespace NSaas {
    class TBroadcastShardingRule : public TShardsDispatcher::IShardingRule {
    public:
        TBroadcastShardingRule(const TShardsDispatcher::TContext& context)
            : IShardingRule(context)
        {}

        using TShardsDispatcher::IShardingRule::GetShard;
        NSearchMapParser::TShardIndex GetShard(const TStringBuf&, TKeyPrefix) const override {
            return 0;
        }

        bool CheckInterval(NSearchMapParser::TShardIndex, const TInterval<NSearchMapParser::TShardIndex>&) const override {
            return true;
        }

        bool CheckSearchInterval(TStringBuf, TKeyPrefix, const TInterval<NSearchMapParser::TShardIndex>&) const override {
            return true;
        }

        bool CheckMessage(const NRTYServer::TMessage&, TString&) const override {
            return true;
        }

        void EnumerateIntervals(TStringBuf /*url*/, TKeyPrefix /*kps*/, const TShardIntervals& sortedIntervals,
                                        IShardIntervalCallback& callback) const override {
            for (size_t i = 0, imax = sortedIntervals.size(); i < imax; ++i) {
                callback.OnShardInterval(i);
            }
        }

        static TShardsDispatcher::IShardingRule::TFactory::TRegistrator<TBroadcastShardingRule> Registrator;
    };

    TShardsDispatcher::IShardingRule::TFactory::TRegistrator<TBroadcastShardingRule> TBroadcastShardingRule::Registrator(Broadcast);
}
