#include "kps.h"

#include <saas/protos/rtyserver.pb.h>

#include <library/cpp/logger/global/global.h>

namespace NSaas {
    class TExternalShardingRule : public TKpsShardingRule {
    public:
        TExternalShardingRule(const TShardsDispatcher::TContext& context)
            : TKpsShardingRule(context)
        {
            VERIFY_WITH_LOG(context.KpsShift == 0, "External sharding do not supports shift");
        }

        NSearchMapParser::TShardIndex GetShard(const NRTYServer::TMessage& message) const override {
            Y_ASSERT(message.HasExternalShard());
            const ui64 shard = message.GetExternalShard();

            return TKpsShardingRule::GetPrefixShard(shard, Context);
        }

        NSearchMapParser::TShardIndex GetShard(const TStringBuf& /*url*/, TKeyPrefix /*kps*/) const override {
            FAIL_LOG("incorrect usage");
        }

        bool CheckMessage(const NRTYServer::TMessage& message, TString& error) const override {
            if (!message.HasExternalShard()) {
                error = "Message doesn't have ExternalShard";
                return false;
            }
            return true;
        }

        static TShardsDispatcher::IShardingRule::TFactory::TRegistrator<TExternalShardingRule> RegistratorExt;
    };

    TShardsDispatcher::IShardingRule::TFactory::TRegistrator<TExternalShardingRule> TExternalShardingRule::RegistratorExt(External);
}
