#pragma once

#include <saas/library/sharding/sharding.h>

namespace NSaas {
    class TUrlShardingRule : public TShardsDispatcher::IShardingRule {
    public:
        TUrlShardingRule(const TShardsDispatcher::TContext& context);

        using TShardsDispatcher::IShardingRule::GetShard;
        virtual NSearchMapParser::TShardIndex GetShard(const TStringBuf& url, TKeyPrefix kps) const override;
        virtual bool CheckSearchInterval(TStringBuf url, TKeyPrefix kps, const TInterval<NSearchMapParser::TShardIndex>& interval) const override;
        virtual bool CheckMessage(const NRTYServer::TMessage& message, TString& error) const override;

        virtual void EnumerateIntervals(TStringBuf url, TKeyPrefix kps, const TShardIntervals& sortedIntervals,
                                        IShardIntervalCallback& callback) const override;

        static NSearchMapParser::TShardIndex GetUrlShard(const TStringBuf& url, const NSearchMapParser::TShardIndex shards);

    private:
        static TShardsDispatcher::IShardingRule::TFactory::TRegistrator<TUrlShardingRule> Registrator;
    };
}
