#pragma once
#include <google/protobuf/message.h>
#include <util/stream/input.h>
#include <util/stream/output.h>
#include <util/generic/yexception.h>

class ISocketAdapter {
public:
    virtual bool ReadMessage(::google::protobuf::Message& message) const = 0;
    virtual void WriteMessage(const ::google::protobuf::Message& message, const TString& request="") const = 0;
    virtual void WriteMessage(const TString& /*message*/, const TString& /*request*/) const {
        ythrow yexception() << "Not implemented: 'Send(TString)'";
    }
    virtual ~ISocketAdapter() {}
    ISocketAdapter(IInputStream& input, IOutputStream& output)
        : Input(input)
        , Output(output)
    {
    }
protected:
    IInputStream& Input;
    IOutputStream& Output;
private:
};
