#include "socket_adapter_factory.h"
#include "socket_adapter_simple.h"
#include "socket_adapter_zero_stream.h"
#include "socket_adapter_proto2http.h"
#include "socket_adapter_proto2json.h"
#include "socket_adapter_proto2json_ref.h"

ISocketAdapter* TAdapterFactory::GetAdapterByType(const TString& typeName, IInputStream& input, IOutputStream& output, const TString& service) {
    if (typeName == "default.socket")
        return new TSocketAdapterSimple(input, output);
    if (typeName == "mail")
        return new TSocketAdapterSimple(input, output);
    if (typeName == "proto2http")
        return new TSocketAdapterProto2Http(service, input, output, true);
    if (typeName == "proto2json")
        return new TSocketAdapterProto2Json(service, input, output, true);
    if (typeName == "proto2json_ref")
        return new TSocketAdapterProto2JsonRef(service, input, output, true);
    if (typeName == "proto2httpDisk")
        return new TSocketAdapterProto2Http(service, input, output, false);
    if (typeName == "proto2jsonDisk")
        return new TSocketAdapterProto2Json(service, input, output, false);
    return new TSocketAdapterZeroCopyStream(input, output);
}
