#pragma once

#include "socket_adapter.h"
#include <saas/protos/rtyserver.pb.h>

class TSocketAdapterProto2Json: public ISocketAdapter {
protected:
    TString Service;
    TString BuildJson(const NRTYServer::TMessage& message) const;
    mutable i64 MessageId;
    mutable bool UsedToWrite;
    mutable bool UsedToRead;
    bool Realtime;

public:
    TSocketAdapterProto2Json(const TString& service, IInputStream& input, IOutputStream& output, bool realtime);
    virtual bool ReadMessage(::google::protobuf::Message& message) const override;
    virtual void WriteMessage(const ::google::protobuf::Message& message, const TString& request="") const override;
    virtual void WriteMessage(const TString& message, const TString& request) const override;
    virtual ~TSocketAdapterProto2Json() override {}
protected:
};

