#pragma once

#include <saas/protos/sti_report.pb.h>
#include <util/generic/hash.h>

namespace NSaas {

class TYTLaunchReport {
public:
    TYTLaunchReport() {
    }

    TYTLaunchReport(const TString& pathToRead);

    void AddTimestamp(ui64 timestamp);
    void Flush(const TString& filePath);
    void AddError(const TString& error);
    void AddSensorValue(const TString& sensorName, double value);
    void AddComment(const TString& comment);

    const TYTReportProto& GetReport() const;
    THashMap<TString, double> GetSignals() const;

private:
    TYTReportProto ReportProto;
};

}
