#pragma once

#include <library/cpp/yconf/conf.h>
#include <util/datetime/base.h>
#include <util/folder/path.h>
#include <util/generic/string.h>

namespace NJson {
    class TJsonValue;
}

namespace NSaas {

    struct TRTYStorageOptions {
        TString SearchHost;
        TString IndexHost;
        ui32 SearchPort;
        ui32 IndexPort;
        TString IndexUrl;
        TString SearchService;
        ui64 Prefix;

        TRTYStorageOptions();
        NJson::TJsonValue SerializeToJson() const;
        bool DeserializeFromJson(const NJson::TJsonValue& value);
        void Init(const TYandexConfig::Section& section);
        TString ToString() const;
    };

    struct TMongoStorageOptions {
        TString Uri;
        TString DB;
        TString CollectionPrefix;
        bool DeserializeFromJson(const NJson::TJsonValue& value);
        NJson::TJsonValue SerializeToJson() const;
        TString GetActualCollection() const;
        TString GetHistoryCollection() const;
        void Init(const TYandexConfig::Section& section);
        TString ToString() const;
    };

    struct TLocalStorageOptions {
        TFsPath Root = "saas1";
        bool FlushOnWrite = false;
        bool DeserializeFromJson(const NJson::TJsonValue& value);
        NJson::TJsonValue SerializeToJson() const;
        void Init(const TYandexConfig::Section& section);
        TString ToString() const;
    };

    struct TZooStorageOptions {
        TString Root = "saas1";
        TString Address;
        ui32 LogLevel = 3; // LL_INFO
        bool DeserializeFromJson(const NJson::TJsonValue& value);
        NJson::TJsonValue SerializeToJson() const;
        void Init(const TYandexConfig::Section& section);
        TString ToString() const;
    };

    struct TDistributedLockOptions {
        bool Enabled = false;
        TDuration DisconnectTimeout = TDuration::Seconds(1);
        TDuration RetryLockTimeout = TDuration::MilliSeconds(100);
        ui32 ConnectAttemps = 10;
        NJson::TJsonValue SerializeToJson() const;
        bool DeserializeFromJson(const NJson::TJsonValue& value);
        void Init(const TYandexConfig::Section& section);
        TString ToString() const;
    };

    struct TStorageOptions {
        enum TStorageType { ZOO, LOCAL, RTY, MONGO };
        TStorageOptions();
        NJson::TJsonValue SerializeToJson() const;
        bool DeserializeFromJson(const NJson::TJsonValue& value);
        void Init(const TYandexConfig::Section& section);
        TString ToString() const;

        TStorageType Type = ZOO;
        ui64 ClusterTaskLifetimeSec = 0;
        TString QueueName = "saas_service";

        TRTYStorageOptions RTYStorage;
        TMongoStorageOptions MongoOptions;
        TDistributedLockOptions DistrLock;
        TZooStorageOptions ZooOptions;
        TLocalStorageOptions LocalOptions;
    };

};
