#pragma once

#include <saas/library/storage/abstract.h>

#include <saas/util/mongo/engine.h>

namespace NSaas {

    class TMongoStorage: public IVersionedStorage {
    public:
        static const i64 LATEST_VERSION = -1;

        TMongoStorage(const IVersionedStorage::TOptions& options);
        virtual ~TMongoStorage();
        virtual bool GetVersion(const TString& key, i64& version) const override;
        virtual bool RemoveNode(const TString& key, bool withHistory = false) const override;
        virtual bool ExistsNode(const TString& key) const override;
        virtual bool GetValue(const TString& key, TString& result, i64 version = LATEST_VERSION, bool lock = true) const override;
        virtual bool SetValue(const TString& key, const TString& value, bool storeHistory = true, bool lock = true, i64* version = nullptr) const override;
        virtual bool GetNodes(const TString& key, TVector<TString>& result, bool withDirs = false) const override;

        virtual bool CreatePersistentSequentialNode(const TString& key, const TString& data) const override;
        static IVersionedStorage::TFactory::TRegistrator<TMongoStorage> Registrator;

    protected:
        virtual TAbstractLock::TPtr NativeWriteLockNode(const TString& path, TDuration timeout = TDuration::Seconds(100000)) const override;
        virtual TAbstractLock::TPtr NativeReadLockNode(const TString& path, TDuration timeout = TDuration::Seconds(100000)) const override;

    private:
        bool IsListNode(const TString& key) const;

        THolder<IVersionedStorage> ZooStorage;
        const TMongoStorageOptions Config;
        NUtil::TMongoEngine::TConnectionsPoolPtr ConnectionsPool;
    };
}
