#include "kv_proto_opts.h"
#include <saas/library/string_utils/ut/sample_for_simple_reflection.pb.h>
#include <library/cpp/protobuf/util/is_equal.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TKvProtoOptsTest) {
    Y_UNIT_TEST(TestSerialize) {
        TSample sample;
        sample.SetOneStr("asdf");
        sample.SetOneInt(-5);
        sample.SetOneEnum(TSample::V2);
        TString kv = NUtil::FormatKvOptions(sample);
        UNIT_ASSERT_VALUES_EQUAL("OneStr=asdf, OneInt=-5, OneEnum=V2", kv);

        TSample opts = NUtil::ParseKvOptions<TSample>(TStringBuf(kv));
        UNIT_ASSERT_VALUES_EQUAL("asdf", opts.GetOneStr());
        UNIT_ASSERT_VALUES_EQUAL((int)TSample::V2, (int)opts.GetOneEnum());
        UNIT_ASSERT(NProtoBuf::IsEqual(sample, opts));


        TSample s2;
        s2.SetOneInt(0);
        UNIT_ASSERT_VALUES_EQUAL("OneInt=0", NUtil::FormatKvOptions(s2));
        UNIT_ASSERT_EXCEPTION(NUtil::ParseKvOptions<TSample>("OneEnum=1"), yexception);
        UNIT_ASSERT_NO_EXCEPTION(NUtil::ParseKvOptions<TSample>(""));

        TSample empty;
        UNIT_ASSERT(NProtoBuf::IsEqual(empty, NUtil::ParseKvOptions<TSample>("    , =")));
    }
}
