#pragma once

#include <util/stream/str.h>
#include <util/stream/tempbuf.h>

namespace NFormatPrivate {
    template <typename T>
    struct TTskvEscaped {
        const T& Value;
        inline constexpr TTskvEscaped(const T& value) noexcept
            : Value(value)
        {
        }
    };

    void TskvEscapeData(const TTempBuf& buf, IOutputStream& o);

    template <typename T>
    IOutputStream& operator<<(IOutputStream& o, const TTskvEscaped<T>& val) {
        TTempBufOutput buf;
        buf << val.Value;
        TskvEscapeData(buf, o);
        return o;
    }
}

template<typename T>
static constexpr ::NFormatPrivate::TTskvEscaped<T> TskvEscaped(const T& value) noexcept {
    return {value};
}

template<typename T>
inline TString TskvEscapeValue(const T& value) {
    TStringStream s;
    s << TskvEscaped(value);
    return s.Str();
}
