#include "tskv_escape.h"

#include <library/cpp/testing/unittest/registar.h>

using namespace std::string_view_literals;

Y_UNIT_TEST_SUITE(TStatBoxEscapeTest) {
    Y_UNIT_TEST(TestEscaper) {
        // trivial cases
        UNIT_ASSERT_VALUES_EQUAL("", TskvEscapeValue(""));
        UNIT_ASSERT_VALUES_EQUAL(" ", TskvEscapeValue(" "));
        UNIT_ASSERT_VALUES_EQUAL(" 12 ", TskvEscapeValue(TString(" 12 ")));
        UNIT_ASSERT_VALUES_EQUAL(" 12 ", TskvEscapeValue(TStringBuf(" 12 ")));
        UNIT_ASSERT_VALUES_EQUAL("12", TskvEscapeValue(12u));

        // do not change printable quotes and json syntax
        UNIT_ASSERT_VALUES_EQUAL("='\"/%{:}[]", TskvEscapeValue("='\"/%{:}[]"));

        // do not change Unicode symbols and Latin letters
        TStringStream s;
        for (char c = 'A'; c <= 'Z'; c++)
            s << c;
        for (char c = 'a'; c <= 'z'; c++)
            s << c;
        for (char c = '\200'; c != '\377'; c++)
            s << c;
        UNIT_ASSERT_VALUES_EQUAL(s.Str(), TskvEscapeValue(s.Str()));

        // convert Statbox escaped chars as specified
        UNIT_ASSERT_VALUES_EQUAL(TStringBuf("\\0 \\t\\r\\n \\\\ \001"), TskvEscapeValue(TStringBuf("\000 \t\r\n \\ \001"sv)));
    }
}
