#pragma once

#include <library/cpp/logger/global/global.h>

namespace NSaas {

class TTvmLogger: public NTvmAuth::ILogger {
public:
    TTvmLogger(TLog& log)
        : Logger(log)
        , Level(static_cast<int>(Logger.FiltrationLevel()))
    {
    }

    TTvmLogger(const TString& file, int level = static_cast<int>(LOG_MAX_PRIORITY))
        : LoggerPtr(new TLog(file))
        , Logger(*LoggerPtr)
        , Level(level)
    {
    }

    void Log(int level, const TString& msg) override {
        if (level > Level)
            return;
        Logger << TInstant::Now().ToStringLocal() << " level=" << level << " msg: " << msg << "\n";
    }

private:
    THolder<TLog> LoggerPtr;
    TLog& Logger;
    const int Level;
};

};
