#pragma once

#include <library/cpp/tvmauth/client/facade.h>

#include <library/cpp/yconf/conf.h>

namespace NSaas {

struct TTvmSettings {
    TString Secret;
    NTvmAuth::TTvmId ClientId = 0;
    NTvmAuth::NTvmApi::TClientSettings::TDstMap DestinationClients;

    void Merge(const TTvmSettings& settings);
};

class TTvmConfig {
public:
    static const inline TString DEFAULT_ENV_KEY_SECRET = "TVM_SECRET";
    static const inline TString DEFAULT_ENV_KEY_CLIENT_ID = "TVM_CLIENT_ID";
    static const inline TString DEFAULT_CONFIG_KEY_SECRET = "secret";
    static const inline TString DEFAULT_CONFIG_KEY_CLIENT_ID = "client_id";

public:
    void Init(const TYandexConfig::Section& configSection);
    TString ToString(const char* sectionName) const;

    bool IsFilled() const;
    TTvmSettings GetSettings() const;

private:
    void InitSettings();

private:
    TString Secret;
    NTvmAuth::TTvmId ClientId = 0;

    TString EnvKeySecret = DEFAULT_ENV_KEY_SECRET;
    TString EnvKeyClientId = DEFAULT_ENV_KEY_CLIENT_ID;

    TString ConfigKeySecret = DEFAULT_CONFIG_KEY_SECRET;
    TString ConfigKeyClientId = DEFAULT_CONFIG_KEY_CLIENT_ID;
    TString ConfigFilename;

    TString DestinationAlias;
    NTvmAuth::TTvmId DestinationClientId;

    TTvmSettings Settings;
    bool HasIncorrectDestinations = false;
};

using TTvmClientPtr = std::shared_ptr<NTvmAuth::TTvmClient>;

TTvmClientPtr CreateTvmClient(const TTvmSettings& settings, NTvmAuth::TLoggerPtr tvmLogger = MakeIntrusive<NTvmAuth::TCerrLogger>(7));

};
