#include "factory.h"
#include "frame.h"

#include <util/generic/singleton.h>

namespace NSaas {
TUnistatFramePtr TDefaultSaasUnistatFrameFactory::SpawnFrame(TString serviceName) const {
    return new TSaasUnistatFrame(std::move(serviceName));
}

namespace {
    class TUnistatFrameFactoryHolder {
    public:
        TUnistatFrameFactoryHolder()
            : Factory(new TDefaultSaasUnistatFrameFactory())
        {
        }

        const ISaasUnistatFrameFactory& Get() const {
            Y_ASSERT(Factory);
            return *Factory;
        }

        void Set(THolder<ISaasUnistatFrameFactory> newFactory) {
            if (newFactory) {
                Factory = std::move(newFactory);
            }
        }

    private:
        THolder<ISaasUnistatFrameFactory> Factory;
    };
}

const ISaasUnistatFrameFactory& GetGlobalUnistatFrameFactory() {
    return Singleton<TUnistatFrameFactoryHolder>()->Get();
}

void SetGlobalUnistatFrameFactory(THolder<ISaasUnistatFrameFactory> factory) {
    Singleton<TUnistatFrameFactoryHolder>()->Set(std::move(factory));
}
}
