#pragma once

#include <search/unistat_logger/unistat_logger.h>

#include <util/generic/ptr.h>

class TSearchConfig;

namespace NSaas {
class ISaasUnistatFrameFactory {
public:
    virtual ~ISaasUnistatFrameFactory() = default;

    virtual TUnistatFramePtr SpawnFrame(TString serviceName) const = 0;
};

class TDefaultSaasUnistatFrameFactory: public ISaasUnistatFrameFactory {
    virtual TUnistatFramePtr SpawnFrame(TString serviceName) const override;
};

const ISaasUnistatFrameFactory& GetGlobalUnistatFrameFactory();

void SetGlobalUnistatFrameFactory(THolder<ISaasUnistatFrameFactory> factory);
}
