#pragma once

#include <mapreduce/yt/interface/fwd.h>

#include <util/datetime/base.h>
#include <util/generic/fwd.h>

namespace NSaas {
    struct TAttributeCachePrivate;

    struct TAttributeCache {
        explicit TAttributeCache(size_t size);
        ~TAttributeCache() noexcept;

        // zero |lifetime| means no lifetime check
        const NYT::TNode* Get(NYT::ICypressClient& ytClient, const TString& path, const TString& attrName,
                TDuration lifeTime = TDuration::Zero());

    private:
        std::pair<const NYT::TNode*, bool> TryLoadFromCache(const TString& path, const TString& attrName, TDuration lifeTime);

        THolder<TAttributeCachePrivate> P;
    };
}
