#pragma once

#include <saas/library/searchmap/searchmap.h>
#include <mapreduce/yt/interface/common.h>

using TShardIndex = NSearchMapParser::TShardIndex;
using TShardId = TInterval<TShardIndex>;

const NYT::TSortColumns ShardIdKeyColumns({"shard_min", "shard_max"});

template <typename TDerived>
class TShardIdOps {
public:
    void SetShardId(TShardId shardId) {
        This()->SetShardMin(shardId.GetMin());
        This()->SetShardMax(shardId.GetMax());
    }

    TShardId GetShardId() const {
        return TShardId(This()->GetShardMin(), This()->GetShardMax());
    }

private:
    TDerived* This() {
        return static_cast<TDerived*>(this);
    }

    const TDerived* This() const {
        return static_cast<const TDerived*>(this);
    }
};
