#pragma once

#include "shard.h"

#include <mapreduce/yt/client/client.h>
#include <saas/protos/yt.pb.h>

enum class EYTBlobFormat {
    Old     /* "old" */,
    New     /* "new" */
};

class TYTBlob : public TShardIdOps<TYTBlob> {
    NSaas::TYTBlobBase Data;
public:
    TYTBlob() = default;
    TYTBlob(const NYT::TNode& node, EYTBlobFormat format);
    TYTBlob(const NSaas::TYTNewBlobBase& blob);
    TYTBlob(const NSaas::TYTBlobBase& blob)
        : Data(blob)
    {
    }

    NSaas::TYTBlobBase& GetBlobRef() {
        return Data;
    }

    const NSaas::TYTBlobBase& GetBlobRef() const {
        return Data;
    }

    explicit operator NSaas::TYTBlobBase() const {
        return Data;
    }
    explicit operator NSaas::TYTNewBlobBase() const;

public: // TShardIdOps
    void SetShardMin(ui32 shard) {
        Data.SetShardMin(shard);
    }

    void SetShardMax(ui32 shard) {
        Data.SetShardMax(shard);
    }

    ui32 GetShardMin() const {
        return Data.GetShardMin();
    }

    ui32 GetShardMax() const {
        return Data.GetShardMax();
    }
};

EYTBlobFormat GetBlobFormatFromAttrs(NYT::IClientBasePtr client, const NYT::TRichYPath& tablePath);
