#include <kernel/multipart_archive/abstract/data_accessor.h>

#include <saas/library/yt/stream/yt_chunked_output.h>

namespace NRTYArchive {
    class TYTStream : public IWritableDataAccessor {
    public:
        TYTStream(const TFsPath& path, const TConstructContext& /*context*/, bool /*readOnly*/)
            : Output(path.GetName())
            , WritePosition(0)
        {
        }

        TSize GetSize() const override {
            return WritePosition;
        }

        TBlob Read(TSize /*size*/, TOffset /*offset*/) override {
            ythrow yexception() << "Not supported in YT mode" << Endl;
            return TBlob();
        }

        TOffset Write(const void* buffer, TSize size) override {
            TOffset result = WritePosition;
            Output.Write(buffer, size);
            WritePosition += size;
            return result;
        }

        bool IsBuffered() const override {
            return false;
        }

        void Flush() override {
            Output.Flush();
        }

        static IDataAccessor::TFactory::TRegistrator<TYTStream> RegistratorR;
        static IWritableDataAccessor::TFactory::TRegistrator<TYTStream> RegistratorW;
    private:
        TYTCommonChunkedOutput Output;
        TOffset WritePosition;
    };

    IDataAccessor::TFactory::TRegistrator<TYTStream> TYTStream::RegistratorR(IDataAccessor::YT_STREAM);
    IWritableDataAccessor::TFactory::TRegistrator<TYTStream> TYTStream::RegistratorW(IDataAccessor::YT_STREAM);
}
