#include "yt_file_dumper.h"

TYTFileDumper::TYTFileDumper(TString prefix, TYTChunkedOutput::TConstructionContext context, bool sortFiles)
    : Prefix(std::move(prefix))
    , Context(std::move(context))
    , SortFiles(sortFiles)
{
}

void TYTFileDumper::DumpFile(const TFsPath& path, const TString& overrideName) const {
    TYTChunkedOutput output(Context, TFsPath(Prefix) / (overrideName ? overrideName : path.GetName()));
    TUnbufferedFileInput(path).ReadAll(output);
    output.Finish();
}

void TYTFileDumper::DumpFileList(const TFsPath& dir, TFileList& fileList) const {
    fileList.Restart();
    TVector<TString> files;
    while (const char* fileName = fileList.Next()) {
        files.push_back(dir / fileName);
    }
    DumpFileList(std::move(files));
}

void TYTFileDumper::DumpFileList(const TFsPath& dir, const TVector<TString>& fileList) const {
    TVector<TString> files;
    for (auto& fileName : fileList) {
        files.push_back(dir / fileName);
    }
    DumpFileList(std::move(files));
}

void TYTFileDumper::DumpFileList(TVector<TString>&& files) const {
    if (SortFiles) {
        ::Sort(files.begin(), files.end());
    }
    for (const auto& file : files) {
        DumpFile(file);
    }
}

void TYTFileDumper::DumpDirectory(const TFsPath& dir) const {
    TFileList fl;
    fl.Fill(dir, true);
    DumpFileList(dir, fl);
}
