#pragma once

#include <saas/library/yt/stream/yt_chunked_output.h>

#include <util/folder/path.h>
#include <util/folder/filelist.h>

class TYTFileDumper {
public:
    TYTFileDumper(TString prefix, TYTChunkedOutput::TConstructionContext context, bool sortFiles = false);
    void DumpFile(const TFsPath& path, const TString& overrideName = TString()) const;
    void DumpFileList(const TFsPath& dir, TFileList& fileList) const;
    void DumpFileList(const TFsPath& dir, const TVector<TString>& fileList) const;
    void DumpDirectory(const TFsPath& dir) const;

private:
    void DumpFileList(TVector<TString>&& fileList) const;

private:
    const TString Prefix;
    const TYTChunkedOutput::TConstructionContext Context;
    const bool SortFiles{};
};
