#pragma once

#include <mapreduce/yt/interface/client.h>

class TYtLockUnique {
    /**
     * класс берет эксклюзивный лок на path (не обязательно существующий)
     * это реализовано с помощью разделения path=way/child по последнему '/'
     * way - существующаяя папка (если нет, то она создастся и не удалится после работы класса)
     * child - имя файла на который мы берем "эксклюзивную" блокировку
     * берется sharedLock на way с параметром childKey = child (таких блокировок нельзя взять несколько одновременно)
     */
public:
    TYtLockUnique(const TString& serverName, const TString& path, TDuration timeout = TDuration::Minutes(10), ui32 attemptCount = 5, const NYT::TCreateClientOptions& options = NYT::TCreateClientOptions());
    /**
     * @param timeout ограничение времени на взятие лока
     */
    bool TryLock();

    void Unlock();

    ~TYtLockUnique();

private:
    void CreateFolder(const TString& way);
    /**
     * создаёт папку по данному пути, если её не существует
     */

    bool TryLockOnce();

    void AbortTransaction();

private:
    NYT::IClientPtr Client;
    NYT::ITransactionPtr Transaction;
    bool Locked;
    TString Path;
    TDuration Timeout;
    ui32 AttemptCount;
};
