#include "yt_chunked_output.h"

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/stream/str.h>
#include <util/string/join.h>
#include <util/string/printf.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(ChunkedOutputSuite) {
    Y_UNIT_TEST(TestTextChunkedOutput) {
        const TString name("test_name");
        TVector<TString> lines({
           /*123456789012345678901234567890*/
            "This is first line in the text",
            ". And now goes the second one.",
            " Each line is 30 chars long.  ",
            "Except for the last one which ",
            "is sometimes shorter."
        });
        TString text = JoinSeq("", lines);
        TStringStream ss;
        TTextChunkedOutput o(30, &ss, name, false);
        o << text;
        o.Finish();

        for (size_t i = 0; i < lines.size(); i++) {
            TString line, refLine;
            UNIT_ASSERT(ss.ReadLine(line) != 0);
            sprintf(refLine, "%s\t%lu\t%lu\t%s", name.data(), i, lines[i].size(), lines[i].data());
            UNIT_ASSERT_VALUES_EQUAL(line, refLine);
        }
    }

    Y_UNIT_TEST(TestEmptyTextChunkedOutput) {
        const TString name("test_name");
        TStringStream ss;
        TTextChunkedOutput o(30, &ss, name, false);
        o.Finish();

        TString line, refLine;
        UNIT_ASSERT(ss.ReadLine(line) != 0);
        sprintf(refLine, "%s\t%lu\t%lu\t%s", name.data(), 0ul, 0ul, "");
        UNIT_ASSERT_VALUES_EQUAL(line, refLine);
    }

}
