#!/bin/bash

# из исходников в аркадии arcadia/saas/protos,
# arcadia/saas/dispatcher_feeder/protos

echo "Clean protos"
rm -rf protos
mkdir protos

echo "Export rtyserver.proto"
svn export svn+ssh://arcadia.yandex.ru/arc/branches/ys.2011.07/arcadia/saas/protos/rtyserver.proto protos/rtyserver.proto
echo "Export dispatcher_feeder.proto"
svn export svn+ssh://arcadia.yandex.ru/arc/branches/ys.2011.07/arcadia/saas/dispatcher_feeder/protos/dispatcher_feeder.proto protos/dispatcher_feeder.proto

echo "Generate python_out"
protoc --proto_path=protos --python_out=protos protos/rtyserver.proto
protoc --proto_path=protos --python_out=protos protos/dispatcher_feeder.proto

cp protos/*.py indexer_proxy_lib
svn diff indexer_proxy_lib/*_pb2.py | vim -
