%define _builddir	.
%define _sourcedir	.
%define _specdir	.
%define _rpmdir		.

Name:		indexer-proxy
Version:	0.12
Release:	%{revision}%{dist}

Summary:	HTTP interface for rtyserver-dispatcher
License:	Yandex License
Packager:	Boris B. Zhmurov <zhmurov@yandex-team.ru>
Group:		System Environment/Meta
Distribution:	Red Hat Enterprise Linux
Requires(pre):  nginx
Requires(pre):	uwsgi
Requires(pre):	python-flask
Requires(pre):	protobuf-python
Requires:	%{name}-config = %{version}-%{release}

BuildArch:	noarch

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root


%description
HTTP interface for rtyserver-dispatcher

%package config-testing
Summary:	HTTP interface configuration for testing
Requires:	%{name} = %{version}-%{release}
Group:		System Environment/Meta
Provides:	%{name}-config = %{version}-%{release}
Conflicts:	%{name}-config-production
Conflicts:	%{name}-config-sandbox

%description	config-testing
HTTP interface configuration for testing

%package config-sandbox
Summary:	HTTP interface configuration for testing
Requires:	%{name} = %{version}-%{release}
Group:		System Environment/Meta
Provides:	%{name}-config = %{version}-%{release}
Conflicts:	%{name}-config-production
Conflicts:	%{name}-config-testing

%description	config-sandbox
HTTP interface configuration for testing

%package config-production
Summary:	HTTP interface configuration for production
Requires:	%{name} = %{version}-%{release}
Group:		System Environment/Meta
Provides:	%{name}-config = %{version}-%{release}
Conflicts:	%{name}-config-testing
Conflicts:	%{name}-config-sandbox

%description	config-production
HTTP interface configuration for production


%install
%{__rm} -rf %{buildroot}


make DESTDIR=%{buildroot} install

%clean
rm -rf $RPM_BUILD_ROOT


%post
if [ $1 = 1 ] ; then
        /sbin/chkconfig --add indexer-proxy
        /sbin/service indexer-proxy start
elif [ $1 = 2 ] ; then
        /sbin/service indexer-proxy restart
fi
service nginx restart

%preun
/sbin/service indexer-proxy stop
exit 0

%post	config-testing
ln -s -f /etc/indexer_proxy/indexer-proxy.conf.testing /etc/nginx/conf.d/indexer-proxy.conf
ln -s -f /etc/indexer_proxy/uwsgi.xml.testing /etc/indexer_proxy/uwsgi.xml
exit 0

%post	config-sandbox
ln -s -f /etc/indexer_proxy/indexer-proxy.conf.sandbox /etc/nginx/conf.d/indexer-proxy.conf
ln -s -f /etc/indexer_proxy/uwsgi.xml.sandbox /etc/indexer_proxy/uwsgi.xml
exit 0

%post	config-production
ln -s -f /etc/indexer_proxy/indexer-proxy.conf.production /etc/nginx/conf.d/indexer-proxy.conf
ln -s -f /etc/indexer_proxy/uwsgi.xml.production /etc/indexer_proxy/uwsgi.xml
exit 0

%preun	config-testing
if [ $1 = 0 ] ; then
	rm -f /etc/indexer_proxy/uwsgi.xml
	rm -f /etc/nginx/conf.d/indexer-proxy.conf
	service nginx restart
fi
exit 0

%preun	config-sandbox
if [ $1 = 0 ] ; then
	rm -f /etc/indexer_proxy/uwsgi.xml
	rm -f /etc/nginx/conf.d/indexer-proxy.conf
	service nginx restart
fi
exit 0

%preun	config-production
if [ $1 = 0 ] ; then
	rm -f /etc/indexer_proxy/uwsgi.xml
	rm -f /etc/nginx/conf.d/indexer-proxy.conf
	service nginx restart
fi
exit 0

%files
%defattr(-,root,root)
%dir %attr(0755, root,root) /usr/libexec/indexer_proxy
%dir %attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib
%attr(0755, root,root) /var/run/indexer_proxy
%attr(0755, root,root) /var/log/indexer-proxy
%attr(0755, root,root) /var/log/nginx/indexer-proxy

%attr(0755, root,root) /etc/init.d/indexer-proxy
%attr(0755, root,root) /usr/libexec/indexer_proxy/indexer_proxy.py
%attr(0755, root,root) /usr/libexec/indexer_proxy/indexer_proxy.pyc
%attr(0755, root,root) /usr/libexec/indexer_proxy/indexer_proxy.pyo
%attr(0755, root,root) /usr/libexec/indexer_proxy/config.py
%attr(0755, root,root) /usr/libexec/indexer_proxy/config.pyc
%attr(0755, root,root) /usr/libexec/indexer_proxy/config.pyo
%attr(0755, root,root) /usr/libexec/indexer_proxy/generate_service_url.py
%attr(0755, root,root) /usr/libexec/indexer_proxy/generate_service_url.pyc
%attr(0755, root,root) /usr/libexec/indexer_proxy/generate_service_url.pyo

%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/dispatcher_feeder_pb2.py
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/dispatcher_feeder_pb2.pyc
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/dispatcher_feeder_pb2.pyo
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/errors.py
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/errors.pyc
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/errors.pyo
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/__init__.py
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/__init__.pyc
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/__init__.pyo
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/message.py
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/message.pyc
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/message.pyo
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/rtyserver_pb2.py
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/rtyserver_pb2.pyc
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/rtyserver_pb2.pyo
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/utils.py
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/utils.pyc
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/utils.pyo
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/logs.py
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/logs.pyc
%attr(0755, root,root) /usr/lib64/python2.6/indexer_proxy_lib/logs.pyo

%files	config-testing
%dir %attr(0755,root,root) /etc/indexer_proxy/
%attr(0644, root,root) /etc/indexer_proxy/indexer-proxy.conf.testing
%attr(0644, root,root) /etc/indexer_proxy/uwsgi.xml.testing

%files	config-sandbox
%dir %attr(0755,root,root) /etc/indexer_proxy/
%attr(0644, root,root) /etc/indexer_proxy/indexer-proxy.conf.sandbox
%attr(0644, root,root) /etc/indexer_proxy/uwsgi.xml.sandbox

%files	config-production
%dir %attr(0755,root,root) /etc/indexer_proxy/
%attr(0644, root,root) /etc/indexer_proxy/indexer-proxy.conf.production
%attr(0644, root,root) /etc/indexer_proxy/uwsgi.xml.production

%changelog
* Thu Mar 26 2009 Boris B. Zhmurov <zhmurov@yandex-team.ru>
- initial yandex's rpm build
