# -*- coding: utf-8 -*-


class Error(Exception):
    pass


class HttpIndexerProxyError(Error):
    def __init__(self, status_code, status_message, message):
        self.status_code = status_code
        self.status_message = status_message
        self.message = message
        super(HttpIndexerProxyError, self).__init__(self.message)


class IndexerError(Error):
    pass


class IncorrectDocumentError(Error):
    pass


class InternalError(Error):
    pass


class ProtobufError(Error):
    def __init__(self, message):
        self.message = message
        super(ProtobufError, self).__init__(self.message)


class FailedToConnectDispatcher(Error):
    pass


class ClosedConnection(Error):
    pass
