# -*- coding: utf-8 -*-

import logging
import sys


FILE_FORMAT = '[%(process)s %(thread)d] %(asctime)s %(levelname)s %(name)s: %(message)s'
TIME_FORMAT = '%Y-%m-%d %H:%M:%S'


class IndexerProxyHandler(logging.Handler):
    def __init__(self, info_logname=None, exc_logname=None):
        # logging.Handler(logging.Filterer) but Filterer not Filterer(object) :-(
        logging.Handler.__init__(self)
        if info_logname:
            self.info_handler = logging.FileHandler(info_logname)
        else:
            self.info_handler = logging.StreamHandler(sys.stdout)
        if exc_logname:
            self.exc_handler = logging.FileHandler(exc_logname)
        else:
            self.exc_handler = logging.StreamHandler(sys.stderr)

    def setFormatter(self, form):
        self.info_handler.setFormatter(form)
        self.exc_handler.setFormatter(form)

    def emit(self, record):
        if record.levelno <= logging.INFO:
            self.info_handler.emit(record)

        if record.levelno > logging.INFO:
            self.exc_handler.emit(record)
