#!/bin/sh
# chkconfig: 345 98 05


. /etc/rc.d/init.d/functions
. /etc/sysconfig/network

CONFIG=/etc/realtime-suggest.cfg
SCRIPT=/usr/share/suggest-indexer/realtime_suggest.py
PYTHON=/usr/bin/python
ERRLOG=/var/log/suggest/error.log


case "$1" in
	start)
		echo "Starting $NAME"
		# Hello Vlad
		nohup $PYTHON $SCRIPT -c $CONFIG > $ERRLOG 2>&1 &
		sleep 2
		if pgrep -f $SCRIPT > /dev/null 2>&1 ; then
			echo_success "realtime suggest indexer started"
			exit 0
		else
			echo_failure "realtime suggest indexer failed to start"
                        exit 1
		fi
	;;
	stop)
		echo "Stopping $NAME"
		pgrep -f $SCRIPT > /dev/null 2>&1
		if [ $? -eq 1 ] ; then
                        echo_warning "realtime suggest indexer is not running"
                        exit 0
                fi
		ps ax | grep $SCRIPT | grep -v grep | awk '{print $1}' | while read pid ; do kill $pid >/dev/null 2>&1 ; done
		sleep 2
		if pgrep -f $SCRIPT > /dev/null 2>&1 ; then
			echo_failure "realtime suggest indexer failed to stop"
                        exit 1
		else
			echo_success "realtime suggest indexer stopped"
                        exit 0
		fi
	;;
	restart)
		$0 stop
		$0 start
	;;
	*)
                N=/etc/init.d/$NAME
                echo "Usage: $N {start|stop|restart}" >&2
                exit 1
        ;;
esac


