#!/usr/bin/env python
# -*- coding: utf-8 -*-

from optparse import OptionParser
from urlparse import urlparse

import sitemap

def main(url=None, filename=None):
    if url:
        urlset = sitemap.UrlSet.from_url(url)
        f = open('urls_%s.q' % urlparse(url).hostname, 'w')

    if filename:
        urlset = sitemap.UrlSet.from_file(filename)
        f = open('urls_%s.q' % filename.split('/')[-1], 'w')

    for url in urlset:
        f.write('%s\n' % url.loc)

    f.close()


if __name__ == "__main__":
    parser = OptionParser()

    parser.add_option("-u", "--url", dest="url",
        help="sitemap url")

    parser.add_option("-f", "--file", dest="file",
        help="sitemap file")

    options, args = parser.parse_args()

    if (not options.url and not options.file) or (options.url and options.file):
        parser.error("option -u or -f required")

    if options.url:
        main(url=options.url)

    if options.file:
        main(filename=options.file)
