#!/bin/sh

addUrl(){
    URL=$1
    FRESHNESS=$2

    printf "Name AT_STRING key $URL\nIsFromSaas AT_BOOL nokey 1\nSaasKeepRobots AT_BOOL nokey 1\nSaasFreshnessPeriod AT_UI32 nokey $FRESHNESS\n" | ./kiwi_format -c ukrop.search.yandex.net -t KT_HOST -O freshtext | ./freshclient --config ./freshclient_cfg.pb.txt --dataconfig ./data_config.pb.txt
}


echo "$1"

export ARC_PATH="$1"
export ARC_BIN="$1/ukrop_bin"
export RTY="$1/saas/robots"
export UKROP="$1/yweb/robot/ukrop"

echo $UKROP

mkdir -p $ARC_BIN

cp $UKROP/conf/conf-common/data_config.pb.txt $ARC_BIN
cp $RTY/ukrop/freshclient_cfg.pb.txt $ARC_BIN
cp $RTY/ukrop/points.local $ARC_BIN
cp $RTY/ukrop/points.remote $ARC_BIN

cd $ARC_BIN
sed -Ee "s,ed209.search.yandex.net,`hostname`,g" -i"" freshclient_cfg.pb.txt points.local

cd $UKROP/tools/freshclient

ls
echo "freshclient building..."
ya build -r -C freshclient -j 24
cp freshclient $ARC_BIN/freshclient
echo "freshclient building...OK"

cd $ARC_PATH/yweb/robot/tools/kiwi_format
echo "kiwi_format building..."
ya build -r -C kiwi_format -j 24
cp kiwi_format $ARC_BIN/kiwi_format
echo "kiwi_format building...OK"

cd $ARC_BIN

addUrl www.help.yandex.ru 300
addUrl help.yandex.ua 300
addUrl help.yandex.com 300
addUrl yardim.yandex.com.tr 300

addUrl api.yandex.ru 300
addUrl api.yandex.com 300
addUrl api.yandex.com.tr 300

addUrl company.yandex.ru 300
addUrl company.yandex.com 300
addUrl company.yandex.com.tr 300
addUrl sirket.yandex.com.tr 300
