#pragma once

#include <saas/library/sharding/sharding.h>
#include <saas/rtyserver/model/index.h>
#include <saas/rtyserver/pruning_config/pruning_config.h>
#include <saas/util/hex.h>
#include <saas/util/types/interval.h>

#include <kernel/keyinv/hitlist/invsearch.h>
#include <kernel/search_daemon_iface/reqtypes.h>
#include <library/cpp/balloc/optional/operators.h>
#include <library/cpp/http/misc/httpreqdata.h>
#include <library/cpp/mediator/messenger.h>

#include <util/stream/output.h>
#include <util/string/hex.h>
#include <util/system/condvar.h>
#include <util/system/thread.h>
#include <util/thread/factory.h>

class TDocHandle;

namespace NJson {
    class TJsonValue;
}

namespace NGroupingAttrs {
    class TDocsAttrs;
}

namespace NMetaProtocol {
    class TDocument;
}

namespace NRTYFactors {
    class TConfig;
}

class IIndexerManager : public IMessageProcessor, public IThreadFactory::IThreadAble {
protected:
    TMutex MutexAction;
    std::atomic<bool> IsActionsActive;
    TCondVar CondVarDoAction;

protected:
    virtual void DoOnStop() {};

public:
    IIndexerManager(): IsActionsActive(true) {}
    virtual ~IIndexerManager() {}

    virtual void DoAction() {}
    virtual void OpenIndexers() {}
    virtual void CloseIndexers(bool /*rigidStop*/) {}

    virtual bool Process(IMessage* /*message*/) { return false; }

    virtual void StopActions() {
        TGuard<TMutex> g(MutexAction);
        UnregisterGlobalMessageProcessor(this);
        DoOnStop();
        IsActionsActive = false;
        CondVarDoAction.Signal();
    }

    virtual void DoExecute() {
        ThreadDisableBalloc();
        RegisterGlobalMessageProcessor(this);
        TThread::SetCurrentThreadName("IndexerManager");
        TGuard<TMutex> g(MutexAction);
        while (IsActionsActive) {
            CondVarDoAction.Wait(MutexAction);
            DoAction();
        }
    }

};
