#include "doc_id_candidate.h"

#include <library/cpp/digest/md5/md5.h>

TDocIdCandidate::THash TDocIdCandidate::GetHash() const {
    VERIFY_WITH_LOG(KeyPrefix != Max<ui64>() && !!Url, "url or kps has not been set");
    THash hash;
    MD5 hasher;
    hasher.Update(Url.data(), Url.size());
    hasher.Update(&KeyPrefix, sizeof(KeyPrefix));
    hasher.Final(hash.Ptr());
    return hash;
}

