#pragma once

#include "doc_id_candidate.h"

struct TDocSearchInfo : public TDocIdCandidate {
public:
    TDocSearchInfo(const TString& url, ui64 keyprefix)
        : TDocIdCandidate(url, keyprefix)
        , SearcherId(Max<ui32>())
    {}

    TDocSearchInfo(const TString& url, ui32 docId, ui64 keyprefix, const TString& indexName = TString())
        : TDocIdCandidate(url, docId, keyprefix)
        , SearcherId(Max<ui32>())
        , IndexName(indexName)
    {}

    TDocSearchInfo(const TString& url, ui32 docId, ui64 keyprefix, const TString& indexName, const TString& category)
        : TDocIdCandidate(url, docId, keyprefix)
        , SearcherId(Max<ui32>())
        , IndexName(indexName)
        , Category(category)
    {}

    TDocSearchInfo(const TString& url, ui32 docId, ui32 searcherId, ui64 keyprefix, const TString& indexName, const TString& category)
        : TDocIdCandidate(url, docId, keyprefix)
        , SearcherId(searcherId)
        , IndexName(indexName)
        , Category(category)
    {}

    TDocSearchInfo(const TString& url, ui32 docId, ui32 searcherId, ui64 keyprefix, const TString& indexName, const TString& category, const TString& fullDocId)
        : TDocIdCandidate(url, docId, keyprefix, fullDocId)
        , SearcherId(searcherId)
        , IndexName(indexName)
        , Category(category)
    {}

    ui32 GetSearcherId() const {
        VERIFY_WITH_LOG(SearcherId != Max<ui32>(), "docid has not set");
        return SearcherId;
    }

    void SetSearcherId(ui32 searcherid) {
        SearcherId = searcherid;
    }

    const TString& GetIndexName() const {
        VERIFY_WITH_LOG(!!IndexName, "IndexName has not set");
        return IndexName;
    }

    bool HasIndexName() const {
        return !!IndexName;
    }

    void SetIndexName(const TString& indexName) {
        IndexName = indexName;
    }

    const TString& GetCategory() const {
        VERIFY_WITH_LOG(!!Category, "Category has not set");
        return Category;
    }

private:
    ui32 SearcherId;
    TString IndexName;
    TString Category;
};
