#pragma once

#include <kernel/urlid/doc_handle.h>

#include <library/cpp/mediator/messenger.h>
#include <library/cpp/json/json_value.h>

class TMessageGetDocInfo : public IMessage {
public:
    const TDocHandle DocId;
    bool HasReply;
    NJson::TJsonValue Reply;
    TString ErrorMessage;

public:
    TMessageGetDocInfo(const TDocHandle& docId)
        : DocId(docId)
        , HasReply(false)
        , Reply(NJson::JSON_MAP)
        , ErrorMessage("incorrect docid")
    {}
};

