#pragma once

#include <library/cpp/mediator/messenger.h>

#include "doc_search_info.h"

#include <util/generic/string.h>
#include <util/system/mutex.h>

class TMessageSearchDocIds: public IMessage {
public:
    class TSearchInfoProcessor {
    public:
        virtual ~TSearchInfoProcessor() {};
        virtual void Process(const TDocSearchInfo& result) = 0;
        virtual int FinishPage(ui32 page) = 0;
    };

    explicit TMessageSearchDocIds(TString query, TSearchInfoProcessor* searchInfoProcessor = nullptr);

    void AdditionalReserve(ui32 size);

    void AddResult(const TDocSearchInfo& result);

    int FinishPage(ui32 page);

    const TString& GetQuery() {
        return Query;
    }

    const TVector<TDocSearchInfo>& GetResult() const {
        return Result;
    }

private:
    TString Query;
    TSearchInfoProcessor* SearchInfoProcessor;
    TVector<TDocSearchInfo> Result;
    TMutex Mutex;
};

